/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.extendedcrafting.crafting.recipe;

import com.blakebr0.cucumber.crafting.ISpecialRecipe;
import com.blakebr0.extendedcrafting.api.crafting.ICombinationRecipe;
import com.blakebr0.extendedcrafting.api.crafting.RecipeTypes;
import com.blakebr0.extendedcrafting.config.ModConfigs;
import com.blakebr0.extendedcrafting.init.ModRecipeSerializers;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class CombinationRecipe
implements ISpecialRecipe,
ICombinationRecipe {
    private final ResourceLocation recipeId;
    private final ItemStack output;
    private final NonNullList<Ingredient> ingredients;
    private final int powerCost;
    private final int powerRate;
    private final List<Component> inputsList;

    public CombinationRecipe(ResourceLocation recipeId, NonNullList<Ingredient> ingredients, ItemStack output, int powerCost) {
        this(recipeId, ingredients, output, powerCost, (Integer)ModConfigs.CRAFTING_CORE_POWER_RATE.get());
    }

    public CombinationRecipe(ResourceLocation recipeId, NonNullList<Ingredient> ingredients, ItemStack output, int powerCost, int powerRate) {
        this.recipeId = recipeId;
        this.ingredients = ingredients;
        this.output = output;
        this.powerCost = powerCost;
        this.powerRate = powerRate;
        this.inputsList = new ArrayList<Component>();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.output;
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializers.COMBINATION;
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.COMBINATION;
    }

    public ItemStack assemble(IItemHandler inventory) {
        return this.output.m_41777_();
    }

    public ItemStack m_5874_(Container inv) {
        return this.output.m_41777_();
    }

    public boolean matches(IItemHandler inventory) {
        ItemStack input = inventory.getStackInSlot(0);
        return ((Ingredient)this.ingredients.get(0)).test(input) && super.matches(inventory);
    }

    public boolean m_5818_(Container inv, Level level) {
        return this.matches((IItemHandler)new InvWrapper(inv));
    }

    @Override
    public int getPowerCost() {
        return this.powerCost;
    }

    @Override
    public int getPowerRate() {
        return this.powerRate;
    }

    @Override
    public List<Component> getInputsList() {
        return this.inputsList;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<CombinationRecipe> {
        public CombinationRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            NonNullList inputs = NonNullList.m_122779_();
            Ingredient input = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"input"));
            inputs.add((Object)input);
            JsonArray ingredients = GsonHelper.m_13933_((JsonObject)json, (String)"ingredients");
            for (int i = 0; i < ingredients.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredients.get(i));
                inputs.add((Object)ingredient);
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            if (!json.has("powerCost")) {
                throw new JsonSyntaxException("Missing powerCost for combination crafting recipe");
            }
            int powerCost = GsonHelper.m_13927_((JsonObject)json, (String)"powerCost");
            int powerRate = GsonHelper.m_13824_((JsonObject)json, (String)"powerRate", (int)((Integer)ModConfigs.CRAFTING_CORE_POWER_RATE.get()));
            return new CombinationRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, powerCost, powerRate);
        }

        public CombinationRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int size = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)size, (Object)Ingredient.f_43901_);
            for (int i = 0; i < size; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int powerCost = buffer.m_130242_();
            int powerRate = buffer.m_130242_();
            return new CombinationRecipe(recipeId, (NonNullList<Ingredient>)inputs, output, powerCost, powerRate);
        }

        public void toNetwork(FriendlyByteBuf buffer, CombinationRecipe recipe) {
            buffer.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(recipe.output);
            buffer.m_130130_(recipe.powerCost);
            buffer.m_130130_(recipe.powerRate);
        }
    }
}

